/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Sourcable;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45PruneableClassifierTree;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.PruneableClassifierTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matchable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class J48
extends AbstractClassifier
implements OptionHandler,
Drawable,
Matchable,
Sourcable,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler,
PartitionGenerator {
    static final long serialVersionUID = -217733168393644444L;
    protected ClassifierTree m_root;
    private boolean m_unpruned = false;
    private boolean m_collapseTree = true;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_useMDLcorrection = true;
    private boolean m_useLaplace = false;
    private boolean m_reducedErrorPruning = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_subtreeRaising = true;
    private boolean m_noCleanup = false;
    private int m_Seed = 1;

    public String globalInfo() {
        return "Class for generating a pruned or unpruned C4.5 decision tree. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Ross Quinlan");
        result.setValue(TechnicalInformation.Field.YEAR, "1993");
        result.setValue(TechnicalInformation.Field.TITLE, "C4.5: Programs for Machine Learning");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers");
        result.setValue(TechnicalInformation.Field.ADDRESS, "San Mateo, CA");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        try {
            result = !this.m_reducedErrorPruning ? new C45PruneableClassifierTree(null, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup, this.m_collapseTree).getCapabilities() : new PruneableClassifierTree(null, !this.m_unpruned, this.m_numFolds, !this.m_noCleanup, this.m_Seed).getCapabilities();
        }
        catch (Exception e) {
            result = new Capabilities(this);
            result.disableAll();
        }
        result.setOwner(this);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        ModelSelection modSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances, this.m_useMDLcorrection) : new C45ModelSelection(this.m_minNumObj, instances, this.m_useMDLcorrection);
        this.m_root = !this.m_reducedErrorPruning ? new C45PruneableClassifierTree(modSelection, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup, this.m_collapseTree) : new PruneableClassifierTree(modSelection, !this.m_unpruned, this.m_numFolds, !this.m_noCleanup, this.m_Seed);
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modSelection).cleanup();
        } else {
            ((C45ModelSelection)modSelection).cleanup();
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    @Override
    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance, this.m_useLaplace);
    }

    @Override
    public int graphType() {
        return 1;
    }

    @Override
    public String graph() throws Exception {
        return this.m_root.graph();
    }

    @Override
    public String prefix() throws Exception {
        return this.m_root.prefix();
    }

    @Override
    public String toSource(String className) throws Exception {
        StringBuffer[] source = this.m_root.toSource(className);
        return "class " + className + " {\n\n" + "  public static double classify(Object[] i)\n" + "    throws Exception {\n\n" + "    double p = Double.NaN;\n" + source[0] + "    return p;\n" + "  }\n" + source[1] + "}\n";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(12);
        newVector.addElement(new Option("\tUse unpruned tree.", "U", 0, "-U"));
        newVector.addElement(new Option("\tDo not collapse tree.", "O", 0, "-O"));
        newVector.addElement(new Option("\tSet confidence threshold for pruning.\n\t(default 0.25)", "C", 1, "-C <pruning confidence>"));
        newVector.addElement(new Option("\tSet minimum number of instances per leaf.\n\t(default 2)", "M", 1, "-M <minimum number of instances>"));
        newVector.addElement(new Option("\tUse reduced error pruning.", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet number of folds for reduced error\n\tpruning. One fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        newVector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        newVector.addElement(new Option("\tDon't perform subtree raising.", "S", 0, "-S"));
        newVector.addElement(new Option("\tDo not clean up after the tree has been built.", "L", 0, "-L"));
        newVector.addElement(new Option("\tLaplace smoothing for predicted probabilities.", "A", 0, "-A"));
        newVector.addElement(new Option("\tDo not use MDL correction for info gain on numeric attributes.", "J", 0, "-J"));
        newVector.addElement(new Option("\tSeed for random data shuffling (default 1).", "Q", 1, "-Q <seed>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString;
        String minNumString = Utils.getOption('M', options);
        this.m_minNumObj = minNumString.length() != 0 ? Integer.parseInt(minNumString) : 2;
        this.m_binarySplits = Utils.getFlag('B', options);
        this.m_useLaplace = Utils.getFlag('A', options);
        this.m_useMDLcorrection = !Utils.getFlag('J', options);
        this.m_unpruned = Utils.getFlag('U', options);
        this.m_collapseTree = !Utils.getFlag('O', options);
        this.m_subtreeRaising = !Utils.getFlag('S', options);
        this.m_noCleanup = Utils.getFlag('L', options);
        if (this.m_unpruned && !this.m_subtreeRaising) {
            throw new Exception("Subtree raising doesn't need to be unset for unpruned tree!");
        }
        this.m_reducedErrorPruning = Utils.getFlag('R', options);
        if (this.m_unpruned && this.m_reducedErrorPruning) {
            throw new Exception("Unpruned tree and reduced error pruning can't be selected simultaneously!");
        }
        String confidenceString = Utils.getOption('C', options);
        if (confidenceString.length() != 0) {
            if (this.m_reducedErrorPruning) {
                throw new Exception("Setting the confidence doesn't make sense for reduced error pruning.");
            }
            if (this.m_unpruned) {
                throw new Exception("Doesn't make sense to change confidence for unpruned tree!");
            }
            this.m_CF = new Float(confidenceString).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception("Confidence has to be greater than zero and smaller than one!");
            }
        } else {
            this.m_CF = 0.25f;
        }
        if ((numFoldsString = Utils.getOption('N', options)).length() != 0) {
            if (!this.m_reducedErrorPruning) {
                throw new Exception("Setting the number of folds doesn't make sense if reduced error pruning is not selected.");
            }
            this.m_numFolds = Integer.parseInt(numFoldsString);
        } else {
            this.m_numFolds = 3;
        }
        String seedString = Utils.getOption('Q', options);
        this.m_Seed = seedString.length() != 0 ? Integer.parseInt(seedString) : 1;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[16];
        int current = 0;
        if (this.m_noCleanup) {
            options[current++] = "-L";
        }
        if (!this.m_collapseTree) {
            options[current++] = "-O";
        }
        if (this.m_unpruned) {
            options[current++] = "-U";
        } else {
            if (!this.m_subtreeRaising) {
                options[current++] = "-S";
            }
            if (this.m_reducedErrorPruning) {
                options[current++] = "-R";
                options[current++] = "-N";
                options[current++] = "" + this.m_numFolds;
                options[current++] = "-Q";
                options[current++] = "" + this.m_Seed;
            } else {
                options[current++] = "-C";
                options[current++] = "" + this.m_CF;
            }
        }
        if (this.m_binarySplits) {
            options[current++] = "-B";
        }
        options[current++] = "-M";
        options[current++] = "" + this.m_minNumObj;
        if (this.m_useLaplace) {
            options[current++] = "-A";
        }
        if (!this.m_useMDLcorrection) {
            options[current++] = "-J";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data when reduced-error pruning is used.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
    }

    public String useLaplaceTipText() {
        return "Whether counts at leaves are smoothed based on Laplace.";
    }

    public boolean getUseLaplace() {
        return this.m_useLaplace;
    }

    public void setUseLaplace(boolean newuseLaplace) {
        this.m_useLaplace = newuseLaplace;
    }

    public String useMDLcorrectionTipText() {
        return "Whether MDL correction is used when finding splits on numeric attributes.";
    }

    public boolean getUseMDLcorrection() {
        return this.m_useMDLcorrection;
    }

    public void setUseMDLcorrection(boolean newuseMDLcorrection) {
        this.m_useMDLcorrection = newuseMDLcorrection;
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        if (this.m_unpruned) {
            return "J48 unpruned tree\n------------------\n" + this.m_root.toString();
        }
        return "J48 pruned tree\n------------------\n" + this.m_root.toString();
    }

    @Override
    public String toSummaryString() {
        return "Number of leaves: " + this.m_root.numLeaves() + "\n" + "Size of the tree: " + this.m_root.numNodes() + "\n";
    }

    public double measureTreeSize() {
        return this.m_root.numNodes();
    }

    public double measureNumLeaves() {
        return this.m_root.numLeaves();
    }

    public double measureNumRules() {
        return this.m_root.numLeaves();
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureTreeSize");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (j48)");
    }

    public String unprunedTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean v) {
        if (v) {
            this.m_reducedErrorPruning = false;
        }
        this.m_unpruned = v;
    }

    public String collapseTreeTipText() {
        return "Whether parts are removed that do not reduce training error.";
    }

    public boolean getCollapseTree() {
        return this.m_collapseTree;
    }

    public void setCollapseTree(boolean v) {
        this.m_collapseTree = v;
    }

    public String confidenceFactorTipText() {
        return "The confidence factor used for pruning (smaller values incur more pruning).";
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float v) {
        this.m_CF = v;
    }

    public String minNumObjTipText() {
        return "The minimum number of instances per leaf.";
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int v) {
        this.m_minNumObj = v;
    }

    public String reducedErrorPruningTipText() {
        return "Whether reduced-error pruning is used instead of C.4.5 pruning.";
    }

    public boolean getReducedErrorPruning() {
        return this.m_reducedErrorPruning;
    }

    public void setReducedErrorPruning(boolean v) {
        if (v) {
            this.m_unpruned = false;
        }
        this.m_reducedErrorPruning = v;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for reduced-error pruning.  One fold is used for pruning, the rest for growing the tree.";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int v) {
        this.m_numFolds = v;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the trees.";
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean v) {
        this.m_binarySplits = v;
    }

    public String subtreeRaisingTipText() {
        return "Whether to consider the subtree raising operation when pruning.";
    }

    public boolean getSubtreeRaising() {
        return this.m_subtreeRaising;
    }

    public void setSubtreeRaising(boolean v) {
        this.m_subtreeRaising = v;
    }

    public String saveInstanceDataTipText() {
        return "Whether to save the training data for visualization.";
    }

    public boolean getSaveInstanceData() {
        return this.m_noCleanup;
    }

    public void setSaveInstanceData(boolean v) {
        this.m_noCleanup = v;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9117 $");
    }

    @Override
    public void generatePartition(Instances data) throws Exception {
        this.buildClassifier(data);
    }

    @Override
    public double[] getMembershipValues(Instance inst) throws Exception {
        return this.m_root.getMembershipValues(inst);
    }

    @Override
    public int numElements() throws Exception {
        return this.m_root.numNodes();
    }

    public static void main(String[] argv) {
        J48.runClassifier(new J48(), argv);
    }
}

